#Master program to set up file structure and run all files 
#Before running this program, make a working directory for the analysis
#Make a "code" folder in the working directory and copy the three other R scripts into it.
#Download the two IPUMS datasets as described in readme.md and convert them to Stata format
#Then modify the paths to the working directory and the two IPUMS Stata files below. 
#Then run this program using the "source" command

#Bring in libraries once for all three programs
library(readstata13)
library(dplyr)
library(Hmisc)
library(reshape2)
library(ggplot2)
library(scales)
library(stringr)

## Modify this section only ##
workdir = '~/projects/raceineq/' #"<path to working directory>"
ipumsusa = 'data/usa_00036.dta' #"data/<filename of IPUMS USA Stata file>"
ipumscps = 'data/cps_00016.dta' #"data/<filename of IPUMS CPS Stata file>"

#Make main directories
setwd(workdir)
dir.create('output')

#Run programs in correct order
source('code/raceineq_inst_rate.R')
source('code/raceineq_prep.R')
source('code/raceineq_graphs.R')
