Replication package for Income Inequality and the Persistence of Racial Economic Disparities

This replication package contains the R scripts and auxilary data files to replicate the analysis in "Income Inequality and the Persistence of Racial Economic Disparities." To begin, create a working directory for the project and copy the "code" and "data" folders into it. 

Next, download the main data files for the paper from from https://www.ipums.org. Two extracts are used:

1) To calculate the institutionalization rate by race, download the following variables from usa.ipums.org:

H	YEAR	Census year
H	DATANUM	Data set number
H	SERIAL	Household serial number
H	HHWT	Household weight
H	GQ	Group quarters status
H	GQTYPE (general)	Group quarters type [general version]
H	GQTYPED (detailed)	Group quarters type [detailed version]
P	PERNUM	Person number in sample unit
P	PERWT	Person weight
P	SEX	Sex
P	AGE	Age
P	RACE (general)	Race [general version]
P	RACED (detailed)	Race [detailed version]
P	HISPAN (general)	Hispanic origin [general version]
P	HISPAND (detailed)	Hispanic origin [detailed version]

Download these for the following samples:
1960 5%		
1970 1% metro fm1
1980 5% state	
1990 5%		
2000 5%		
2006 ACS (the 2001-2005 ACS do not contain institutionalization variables)
2007 ACS		
2008 ACS		
2009 ACS		
2010 ACS		
2011 ACS		
2012 ACS		
2013 ACS		
2014 ACS		
2015 ACS
2016 ACS

2) To conduct the primary analysis, download the following variables for the years 1968-2016 from cps.ipums.org:		

Type	Variable	Label
H		YEAR		Survey year
H		SERIAL		Household serial number
H		ASECFLAG	Flag for ASEC
H		HFLAG		Flag for the 3/8 file 2014
H		MONTH		Month
H		HHINCOME	Total household income
H		CPSID		CPSID, household record
P		RELATE		Relationship to household head
P		AGE			Age
P		SEX			Sex
P		RACE		Race
P		FAMSIZE		Number of own family members in hh
P		FAMUNIT		Family unit membership
P		NATIVITY	Foreign birthplace or parentage
P		HISPAN		Hispanic origin
P		CPSIDP		CPSID, person record
P		PERNUM		Person number in sample unit
P		ASECWT		Annual Social and Economic Supplement Weight
P		FTOTVAL		Total family income
P		INCTOT		Total personal income

Once the data extracts are downloaded, run the companion Stata programs from IPUMS to import them, and save them in Stata format as .dta files. Then open the R script "raceineq_master.R". Modify the path to the working directory and the file names of the two IPUMS .dta files. Then run "raceineq_master.R".

