# Get percentage of country in different income categories according to IPUMS

library(tidyverse)

setwd('~/projects/regionineq/')

# Bring in CZ family income IPUMS results
i80 = read.csv('output/ipums/cz/dta/fam/cz_citymeans_fam_80.csv')
i13 = read.csv('output/ipums/cz/dta/fam/cz_citymeans_fam_13.csv')

# Bring in national family income results
n80 = read.csv('output/ipums/cz/dta/cz_natinfo_80.csv')
nmean80 = filter(n80, samp == 'fam') %>% select(mean) %>% unlist()
i80$pctnat = i80$mean / nmean80

n13 = read.csv('output/ipums/cz/dta/cz_natinfo_13.csv')
nmean13 = filter(n13, samp == 'fam') %>% select(mean) %>% unlist()
i13$pctnat = i13$mean / nmean13

#Drop CZ 34101 from 2013 becasue it's not in 1980
filter(i80, city == '34101') #0 rows
i13 = filter(i13, city != '34101')

i80$inccat = 'middle'
i80[i80$pctnat < .8, 'inccat'] = 'below80'
i80[i80$pctnat > 1.2, 'inccat'] = 'above120'

stats80 = i80 %>% group_by(inccat) %>% summarise(pop = sum(cnt))
stats80$pct = stats80$pop / sum(stats80$pop)
stats80$year = 1980

i13$inccat = 'middle'
i13[i13$pctnat < .8, 'inccat'] = 'below80'
i13[i13$pctnat > 1.2, 'inccat'] = 'above120'

stats13 = i13 %>% group_by(inccat) %>% summarise(pop = sum(cnt))
stats13$pct = stats13$pop / sum(stats13$pop)
stats13$year = 2013

statsout = rbind(stats80,stats13)
write.csv(statsout,'output/sigmagraphs/polarization_ipumsfam.csv',row.names = F)
