#Makes a list mapping each county FIPS to its county name from the maps package

library(dplyr)
library(Hmisc)
library(maps)
library(stringr)
library(RColorBrewer)
library(scales)

setwd('~/projects/regionineq/')

#Create list of all counties and match them to MSAs for mapping out later
#Bring in state lookups
states = read.csv('data/reference/stfips.csv', colClasses =  'character')
states$st = str_pad(states$FIPS.Code, width = 2, pad = '0')
states = states[,c(3,2)]
names(states) = c('st','stname')

#Bring in MSA lookups
msas = read.csv('data/reference/CountyMSA_2013.csv', colClasses = 'character')
msas$st = str_pad(msas$FIPS.State.Code,width = 2, pad = '0')
msas$cnty = str_pad(msas$FIPS.County.Code,width = 3, pad = '0')
msas$fips = paste(msas$st, msas$cnty,sep = '')
msas = msas[,c('fips','CBSA.Code','CBSA.Title')]
names(msas) = c('fips','msa','msaname')

#Manually add counties added since 1990
msas[nrow(msas)+1,] = c('15901','27980','Kahului-Wailuku-Lahaina, HI') #Maui and Kalawao County HI -> Kahului
msas[nrow(msas)+1,] = c('46102','46','South Dakota non-Metro') #Ogalala Lakota County -> Gordon SD
msas[nrow(msas)+1,] = c('55901','43020','Shawano, WI') #Shawano + Menominee County -> Shawano WI
msas[nrow(msas)+1,] = c('02201','2','Alaska non-Metro') #Three Alaska counties that aren't current to the MSAs list are all non-metro according to https://en.wikipedia.org/wiki/Alaska_statistical_areas
msas[nrow(msas)+1,] = c('02231','2','Alaska non-Metro') 
msas[nrow(msas)+1,] = c('02280','2','Alaska non-Metro') 

#Bring in CZs
czs = read.csv('data/reference/czlma903.csv')
czs$fips = str_pad(czs$County.FIPS.Code, 5,pad = '0')
czs$czone = str_pad(czs$CZ90,5,pad = '0')
czs = select(czs, fips, czone)

#Manually add counties added since 1990
czs[nrow(czs)+1,] = c('08014','28900') #Broomfield County CO -> Denver CZ
czs[nrow(czs)+1,] = c('12086','07000') #Miami-Dade County FL -> Miami CZ
czs[nrow(czs)+1,] = c('15901','34703') #Maui and Kalawao County HI -> Kahului
czs[nrow(czs)+1,] = c('46102','27704') #Ogalala Lakota County -> Gordon SD
czs[nrow(czs)+1,] = c('55901','22602') #Shawano + Menominee County -> Shawano WI

#Use county fips data from map package
cntyfips = county.fips
cntyfips$fipstring = str_pad(as.character(cntyfips$fips), width = 5,pad = '0')
cntyfips$st = substr(cntyfips$fipstring,1,2)

cntyfips = merge(cntyfips, msas, by.x = 'fipstring', by.y = 'fips', all.x = T)
cntyfips = merge(cntyfips, states, by = 'st', all.x = T)

cntyfips[is.na(cntyfips$msa),'msaname'] = paste(cntyfips[is.na(cntyfips$msa),'stname'],'non-Metro')
cntyfips[is.na(cntyfips$msa),'msa'] = cntyfips[is.na(cntyfips$msa),'st']

cntyfips$msa = as.numeric(cntyfips$msa)

cntyfips = merge(cntyfips, czs, by.x = 'fipstring',by.y = 'fips', all.x = T)
stopifnot(!is.na(cntyfips$czone))

#Keep only one line for multi-part counties - in the actual
#Maps data they don't get separated out
cntyfips$polyname = gsub(pattern = ':.*','',cntyfips$polyname)
cntyfips = cntyfips[!duplicated(cntyfips),]

write.csv(cntyfips, 'output/mable/cntymsakey.csv',row.names = F)


