#Calculate what percentage of total national income from BEA is
#reported in the Census in 1980 and 2013

library(readstata13)
library(dplyr)

setwd('~/projects/regionineq/')

#Get CPI
cpirs = read.dta13('data/reference/cpirs.dta')
cpi15 = cpirs[cpirs$year == 2015,'rate']
cpi79 = cpirs[cpirs$year == 1979,'rate']
cpi12 = cpirs[cpirs$year == 2012,'rate']

#Get BEA data for 1979 and 2012 to match Census in 1980 and 2011-2015 = 2013
gdp = read.csv('output/bea/dta/nat_gdppc.csv')
gdp79 = gdp %>% filter(year == 1979) %>% select(gdptotnat) %>% unlist() * 1000
gdp12 = gdp %>% filter(year == 2012) %>% select(gdptotnat) %>% unlist() * 1000


#Get Census data for 1980 (asking about 1979)
load('data/ipums/ip80cz.RData')
dta8c$incinf = dta8c$inctot * cpi15 / cpi79
dta8c$wtinc = dta8c$pcwt * dta8c$incinf
ceninc79 = sum(dta8c$wtinc, na.rm = T)

#Calculate ratio of Census to BEA income
ceninc79 / gdp79 #0.7786822

#Get Census data for 2011-2015 (asking about 2010-2014 = 2012)
#Per IPUMS documentation, this is already in 2015 dollars 
#https://usa.ipums.org/usa/acs_multyr.shtml
#Note that when you load ip13.cz the variable name in R is dta15c because that was the year in IPUMS
load('data/ipums/ip13cz.RData')
dta15c$incinf = dta15c$inctot * cpi15 / cpi15
dta15c$wtinc = dta15c$pcwt * dta15c$incinf
ceninc12 = sum(dta15c$wtinc, na.rm = T)

#Calculate ratio
ceninc12 / gdp12 #0.6200389
