#Make stylized cities for figure 1

library(ggplot2)
library(scales)
library(dplyr)

setwd('~/projects/regionineq/')
dir.create('output/stylized')

c1 = c(4,5,6,7,8,8,9,10,11,12)
c2 = c(8,9,10,11,12,12,13,14,15,16)
nat = c(c1,c2)

mean(c1)
mean(c2)
mean(nat)

hist(c1)
plot(density(c1))

d1 = density(c1)
d1 = data.frame(cbind(d1$x,d1$y))
d1$ltype = '1'
names(d1) = c('x','y','ltype')

d2 = density(c2)
d2 = data.frame(cbind(d2$x,d2$y))
d2$ltype = '2'
names(d2) = c('x','y','ltype')

dd = rbind(d1,d2) %>% data.frame()

ggplot() +
  geom_line(data = d1, aes(x = x, y=y)) +
  geom_line(data = d2, aes(x = x, y=y)) +
  scale_x_continuous(limits = c(0,20)) +
  scale_y_continuous(limits = c(0,.25)) 
  
#sorting
s1 = c(nat[nat < 10],10)
s2 = c(nat[nat > 10],10)

mean(s1)
mean(s2)
mean(c(s1,s2))

ds1 = density(s1)
ds1 = data.frame(cbind(ds1$x,ds1$y))
ds1$ltype = '1'
names(ds1) = c('x','y','ltype')

ds2 = density(s2)
ds2 = data.frame(cbind(ds2$x,ds2$y))
ds2$ltype = '2'
names(ds2) = c('x','y','ltype')

ds = rbind(ds1,ds2) %>% data.frame()

ggplot() +
  geom_line(data = ds1, aes(x = x, y=y)) +
  geom_line(data = ds2, aes(x = x, y=y)) +
  scale_x_continuous(limits = c(0,20)) +
  scale_y_continuous(limits = c(0,.25))

#Inequality
i1 = replace(c1,c1>10,c1[c1>10]+1)
i1 = replace(i1,i1<10,i1[i1<10]-1)

i2 = replace(c2,c2>10,c2[c2>10]+1)
i2 = replace(i2,i2<10,i2[i2<10]-1)

mean(i1)
mean(i2)
mean(c(i1,i2))

di1 = density(i1)
di1 = data.frame(cbind(di1$x,di1$y))
di1$s = '1'
names(di1) = c('x','y','ltype')

di2 = density(i2)
di2 = data.frame(cbind(di2$x,di2$y))
di2$s = '2'
names(di2) = c('x','y','ltype')

di = rbind(di1,di2) %>% data.frame()

ggplot() +
  geom_line(data = di1, aes(x = x, y=y)) +
  geom_line(data = di2, aes(x = x, y=y)) +
  scale_x_continuous(limits = c(0,20)) +
  scale_y_continuous(limits = c(0,.25))

#Both
natb = replace(nat, nat < 10, nat[nat<10] -1)
natb = replace(natb, natb > 10, natb[natb>10] +1)
b1 = c(natb[natb < 10],10)
b2 = c(natb[natb > 10],10)

mean(b1)
mean(b2)
mean(c(b1,b2))

db1 = density(b1)
db1 = data.frame(cbind(db1$x,db1$y))
db1$ltype = '1'
names(db1) = c('x','y','ltype')

db2 = density(b2)
db2 = data.frame(cbind(db2$x,db2$y))
db2$ltype = '2'
names(db2) = c('x','y','ltype')

db = rbind(db1, db2) %>% data.frame()

ggplot() +
  geom_line(data = db1, aes(x = x, y=y)) +
  geom_line(data = db2, aes(x = x, y=y)) +
  scale_x_continuous(limits = c(0,20)) +
  scale_y_continuous(limits = c(0,.25))


mean(c1)
mean(s1)
mean(i1)
mean(b1)

mean(c2)
mean(s2)
mean(i2)
mean(b2)

pdf('output/stylized/hypo_a.pdf', width = 5, height = 4)
gplt = ggplot() +
  geom_line(data = dd, aes(x = x, y=y, lty = ltype)) +
  theme_bw()+
  theme(legend.position = c(.9,.8))+
  scale_linetype_discrete(name = '', breaks = c(1,2), labels=  c('City A', 'City B'))+
  scale_x_continuous(limits = c(0,20),name ='Income',labels = dollar) +
  scale_y_continuous(limits = c(0,.25),name = 'Relative density') +
  ggtitle('A: Baseline') 
print(gplt) 
dev.off()

pdf('output/stylized/hypo_b.pdf', width = 5, height = 4)
gplt = ggplot() +
  geom_line(data = ds, aes(x = x, y=y, lty = ltype)) +
  theme_bw()+
  theme(legend.position = c(.9,.8))+
  scale_linetype_discrete(name = '', breaks = c(1,2), labels=  c('City A', 'City B'))+
  scale_x_continuous(limits = c(0,20),name ='Income',labels = dollar) +
  scale_y_continuous(limits = c(0,.25),name = 'Relative density') +
  # geom_vline(xintercept = c(mean(c1),mean(c2)), lty = 1, alpha = .3) +
  # geom_vline(xintercept = c(mean(s1),mean(s2)), lty = 3, alpha = .3) +
  ggtitle('B: Increased sorting') 
print(gplt) 
dev.off()

pdf('output/stylized/hypo_c.pdf', width = 5, height = 4)
gplt = ggplot() +
  geom_line(data = di, aes(x = x, y=y, lty = ltype)) +
  theme_bw()+
  theme(legend.position = c(.9,.8))+
  scale_linetype_discrete(name = '', breaks = c(1,2), labels=  c('City A', 'City B'))+
  scale_x_continuous(limits = c(0,20),name ='Income',labels = dollar) +
  scale_y_continuous(limits = c(0,.25),name = 'Relative density') +
  # geom_vline(xintercept = c(mean(c1),mean(c2)), lty = 1, alpha = .3) +
  # geom_vline(xintercept = c(mean(i1),mean(i2)), lty = 3, alpha = .3) +
  ggtitle('C: Increased inequality') 
print(gplt) 
dev.off()

pdf('output/stylized/hypo_d.pdf', width = 5, height = 4)
gplt = ggplot() +
  geom_line(data = db, aes(x = x, y=y, lty = ltype)) +
  theme_bw()+
  theme(legend.position = c(.9,.8))+
  scale_linetype_discrete(name = '', breaks = c(1,2), labels=  c('City A', 'City B'))+
  scale_x_continuous(limits = c(0,20),name ='Income',labels = dollar) +
  scale_y_continuous(limits = c(0,.25),name = 'Relative density') +
  ggtitle('D: Increased sorting and inequality') 
print(gplt) 
dev.off()
