# Make one clean EQR file
# After call with Bob DeBoer, using this for NY and PA only
# Still adjust for Hartford CT and add Block Island RI
# Leave sales ratios alone

library(tidyverse)


# Get common level ratios for PA
pa_clr = read_csv('nonproprietary_data/state_eqr_data/pa/pa_clr_2019.csv')
pa_clr$cnty = str_pad(pa_clr$COUNTYFP,3, pad = '0')
pa_clr$st = str_pad(pa_clr$STATEFP,2,pad = '0')
pa_clr$eqr = pa_clr$clr / 100


pa_clean = select(pa_clr,st, cnty,eqr )

# Get NY Westchester and Rockland county equalization rates
ny_eqr = read_csv('nonproprietary_data/state_eqr_data/ny/ny_equalization_ratios.csv')
ny_eqr = mutate(ny_eqr,
                COUNTY = str_pad(county,3,pad = '0'),
                STATE = '36',
                eqr = as.numeric(str_trim(`State Equalization Rate`)) / 100)
ny_clean = select(ny_eqr, st = STATE, fuint = loc2,eqr)


out_loc2 = ny_clean

write_csv(out_loc2,'nonproprietary_data/state_eqr_data/state_eqr_clean_loc2.csv')


out_cnty = pa_clean
write_csv(out_cnty, 'nonproprietary_data/state_eqr_data/state_eqr_clean_cnty.csv')

