# Overview program to call all the prep and analysis programs for TFQ

## Change this line to the analysis directory
setwd('~/Dropbox (University of Michigan)/projects/tax_base_fragmentation/replication_package_taxbase/')

dir.create('output')


# Analysis of tax base data
source('analysis_code/analysis_tfq.R') # Compute TFQ 
source('analysis_code/analysis_hilow.R') # Identify tax havens and fiscally impoverished cities, create Tables 2 and 3 and appendix Tables A7.1 and A7.2
source('analysis_code/analysis_econ_segregation.R') # Compute economic segregation numbers

# Analysis of ancillary data
source('analysis_code/analysis_assessors.R') # count of assessing jurisdictions
source('analysis_code/analysis_fisc_cbsa.R') # Preparation of fiscal data to CBSAs for Appendix 4
source('analysis_code/analysis_fisc_regressions.R') # Regressions with fiscal data, Tables 4 and A8.1

# National mapping
source('analysis_code/maps_nation_tfq.R') # Map of TFQ - the states function from tigris wasn't workon on my most recent attempt 10/2/2025
source('analysis_code/maps_nation_dq.R') # Maps of data quality 

# CBSA mapping
source('analysis_code/maps_cbsas_fcr_all.R') # Maps of all CBSAs with colors by FCR
# source('analysis_code/maps_cbsa_fcr_properties_figures.R') # Maps of 3 CBSAs for paper (requires proprietary data to run)

# Make other figures and tables 
source('analysis_code/graphs_sc_proptax_reliance.R') #  Appendix 4 scatter plot comparing to property tax importance
source('analysis_code/graphs_prev_metrics.R') #  Table 1 and Appendix 5 scatter plots comparing segregation and jurisdictional fragmentation to tax base fragmentation
source('analysis_code/graphs_sc_robustness.R') # Appendix 3 scatter plots comparing to other specifications
